<?php
header('Content-Type: application/json');
$apikey = $_POST['apiKey'] ?? '';
if (!$apikey) {
    echo json_encode(['success'=>false, 'message'=>'Chưa nhập API Key!']); exit;
}
$projectUrl = "https://generativelanguage.googleapis.com/v1beta/projects"; // Dự án Gemini cloud
// Google API hiện chưa hỗ trợ endpoint public lấy quota, nên cần giả lập check với 1 request nhỏ
$url = "https://generativelanguage.googleapis.com/v1beta/models/gemini-2.5-flash:countTokens?key=$apikey";
$data = [
   "contents" => [[ "parts" => [["text" => "quota"] ] ]]
];
$resp = @file_get_contents($url,
    false,
    stream_context_create([
        'http' => [
            'method' => 'POST',
            'header' =>
                "Content-Type: application/json\r\n",
            'content' => json_encode($data)
        ]
    ])
);
if (!$resp) {
    echo json_encode(['success'=>false,'message'=>'Không truy cập được API hoặc API key sai!']); exit;
}
$out = json_decode($resp, true);
if (isset($out['error'])) {
    echo json_encode(['success'=>false,'message'=>'API hiện chưa thể truy vấn quota, hoặc đang hết hạn/quota! <br>Lỗi: '.$out['error']['message']]); exit;
}
echo json_encode([
    'success'=>true,
    'quota' => '- Không lấy được số quota trực tiếp qua API public.<br>- Nếu bạn chưa bị hạn chế, API vẫn sử dụng bình thường.<br>- Khi hết quota, API trả về lỗi <code>429 Quota Exceeded</code> hoặc lỗi quota từ Google.<br>- Để biết chi tiết quota từng project cần vào Google Cloud Console IAM & Quotas.'
]);
