<?php
// export.php
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405); exit;
}

$type = $_POST['type'] ?? 'adobe'; // "adobe", "shutterstock", "freepik"
$data = json_decode($_POST['data'] ?? '[]', true);

header('Content-Type: text/csv');
header('Content-Disposition: attachment; filename="export_' . $type . '.csv"');

$output = fopen('php://output', 'w');

if ($type === 'adobe') {
    // Adobe Stock: title,keywords,description,categories
    fputcsv($output, ['title', 'keywords', 'description', 'categories']);
    foreach ($data as $item) {
        fputcsv($output, [
            $item['title'] ?? '',
            $item['keywords'] ?? '',
            $item['description'] ?? '',
            $item['categories'] ?? ''
        ]);
    }
} elseif ($type === 'shutterstock') {
    // Shutterstock: title,description,keywords,categories
    fputcsv($output, ['title', 'description', 'keywords', 'categories']);
    foreach ($data as $item) {
        fputcsv($output, [
            $item['title'] ?? '',
            $item['description'] ?? '',
            $item['keywords'] ?? '',
            $item['categories'] ?? ''
        ]);
    }
} elseif ($type === 'freepik') {
    // Freepik: title, description, tags
    fputcsv($output, ['title', 'description', 'tags']);
    foreach ($data as $item) {
        fputcsv($output, [
            $item['title'] ?? '',
            $item['description'] ?? '',
            $item['keywords'] ?? ''
        ]);
    }
}

fclose($output);
exit;
