<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>AI MetaGen - AI Metadata For Vietnam Stock Footage</title>
    <meta name="description" content="Instantly generate SEO-optimized titles, descriptions, and keywords for Vietnamese stock photos and videos. Powered by AI.">
    <meta name="keywords" content="vietnam footage, stock media, ai metadata, keyword generator, seo optimization">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css">
    <link rel="stylesheet" href="style.css">
</head>
<body>
    <header class="navbar navbar-expand-lg navbar-dark bg-dark shadow-sm">
        <div class="container">
            <a class="navbar-brand" href="#">VietnamFootage Meta AI</a>
            <div class="collapse navbar-collapse">
                <ul class="navbar-nav ms-auto">
                    <li class="nav-item"><a class="nav-link" href="#" data-bs-toggle="modal" data-bs-target="#howToUseModal">How to Use</a></li>
                    <li class="nav-item"><a class="nav-link" href="https://www.vietnamfootage.store" target="_blank">Main Site</a></li>
                </ul>
            </div>
        </div>
    </header>
    <main class="container my-5">
        <div class="row g-5">
            <div class="col-lg-5">
                <!-- Upload & Config Card -->
                <div class="card shadow-sm mb-4">
                    <div class="card-header h5"><i class="bi bi-gear-fill me-2"></i>Configuration</div>
                    <div class="card-body">
					<div class="row g-2 align-items-end mb-3">
					  <div class="col">
						<label for="apiKey" class="form-label mb-1">API Key</label>
							<input type="password" class="form-control" id="apiKey" value="AIzaSyACoqCRfWX8XrQ2EjIf4fVsxuQAdgrR8QI">
					  </div>
					  <div class="col-auto d-flex align-items-end">
						<button id="btnCheckApi" class="btn btn-info py-2 px-3" style="min-width:115px;">Check API</button>
					  </div>
					</div>

						
					<!-- Modal kết quả quota -->
					<div class="modal fade" id="quotaModal" tabindex="-1">
					  <div class="modal-dialog">
						<div class="modal-content">
						  <div class="modal-header"><h5 class="modal-title">Thông tin Gemini API Quota</h5></div>
						  <div class="modal-body" id="quotaInfo"></div>
						  <div class="modal-footer">
							<button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Đóng</button>
						  </div>
						</div>
					  </div>
					</div>
					
						</button>



                        <div class="row">
                            <div class="col-6">
                                <label for="aiEngine" class="form-label">AI Engine</label>
                                <select id="aiEngine" class="form-select">
                                    <option value="gemini" selected>Gemini</option>
                                    <option value="chatgpt">ChatGPT</option>
                                </select>
                            </div>
                            <div class="col-6">
                                <label for="geminiModel" class="form-label">Gemini Model</label>
                                <select id="geminiModel" class="form-select">
                                    <option value="gemini-2.5-flash" selected>2.5 Flash</option>
                                    <option value="gemini-2.5-pro">2.5 Pro</option>
                                </select>
                            </div>
                        </div>
                        <div class="mt-3">
                            <label for="customPrompt" class="form-label">Custom Prompt</label>
                            <textarea class="form-control" id="customPrompt" rows="5">Analyze the thumbnail extracted from the file titled "{filename}".The contents of these files are related to ,  Generate unique, SEO-optimized metadata that follows global trends, compatible with Adobe Stock submission guidelines. Return ONLY valid JSON in the format: { "title": "...", "description": "...", "keywords": ["..."], "categoryId": 3 }. CategoryId must be a number from 1 to 21 using the following mapping:
1 = Animals, 2 = Buildings and Architecture, 3 = Business, 4 = Drinks, 5 = The Environment, 6 = States of Mind, 7 = Food, 8 = Graphic Resources, 9 = Hobbies and Leisure, 10 = Industry, 11 = Landscapes, 12 = Lifestyle, 13 = People, 14 = Plants and Flowers, 15 = Culture and Religion, 16 = Science, 17 = Social Issues, 18 = Sports, 19 = Technology, 20 = Transport, 21 = Travel.</textarea>
                        </div>
                    </div>
                </div>
                <!-- Upload files -->
                <div class="card shadow-sm mb-4">
                    <div class="card-header h5"><i class="bi bi-upload me-2"></i>Upload Files</div>
                    <div class="card-body">
                        <div class="upload-container mb-3">
                            <label class="btn btn-primary btn-lg w-100 mb-3">
                                Upload/Chọn nhiều file
                                <input type="file" id="videoFiles" name="videoFiles[]" multiple hidden>
                            </label>
                            <div id="dropZone" class="dropzone text-center border border-secondary rounded p-3 mb-2">Kéo & thả file vào đây để upload</div>
                            <ul id="fileListContainer" class="list-group"></ul>
                            <div class="progress my-2">
                                <div id="progressBar" class="progress-bar" style="width:0%"></div>
                            </div>
                            <div id="progressCounter"></div>
                            <div id="uploadStatus"></div>
                        </div>
                        <div class="d-grid mt-3">
                            <button id="btnGenerate" class="btn btn-primary btn-lg">
                                <span class="spinner-border spinner-border-sm d-none" role="status" aria-hidden="true"></span>
                                <i class="bi bi-magic me-1"></i> Generate Metadata
                            </button>
                        </div>
                        <div class="mt-3 text-center">
                            <span id="statusMessage" class="fw-medium"></span>
                            <span>Success: <strong id="successCount">0</strong></span>
                            <span>Failed: <strong id="failedCount">0</strong></span>
                        </div>
                    </div>
                </div>
                <!-- Export Format -->
                <div class="card shadow-sm mb-4">
                    <div class="card-header h5"><i class="bi bi-file-earmark-spreadsheet-fill me-2"></i>Export</div>
                    <div class="card-body">
                        <label for="exportFormat" class="form-label">Export Format</label>
                        <select id="exportFormat" class="form-select w-auto d-inline-block">
                            <option value="adobe" selected>Adobe Stock</option>
                            <option value="shutterstock">Shutterstock</option>
                            <option value="freepik">Freepik</option>
                        </select>
                        <button id="btnExport" class="btn btn-success float-end" disabled>
                            <i class="bi bi-file-earmark-spreadsheet-fill me-2"></i>Export to CSV
                        </button>
                    </div>
                </div>
            </div>
            <div class="col-lg-7">
                <!-- Logs/results/thumbnail -->
                <div class="card shadow-sm mb-4">
                    <div class="card-header h5"><i class="bi bi-card-checklist me-2"></i>Processing Results</div>
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-8">
                                <h5>Processing Log</h5>
                                <pre id="log" class="form-control" style="height: 250px"></pre>
                            </div>
                            <div class="col-md-4">
                                <h5>Last Thumbnail</h5>
                                 <!-- <img id="thumbnailPreview" src="https://via.placeholder.com/300/f8f9fa/6c757d?text=Preview" class="img-thumbnail" alt="Thumbnail Preview" />  -->
								<img id="thumbnailPreview" class="img-thumbnail" style="width:100%;height:250px;object-fit:cover;" />

                            </div>
                        </div>
                    </div>
                </div>
                <div class="card shadow-sm mb-4 mt-4">
                    <div class="card-header h5"><i class="bi bi-card-list me-2"></i>Metadata Results</div>
                    <div class="card-body">
                        <div id="resultsContainer" class="results-container"></div>
                    </div>
                </div>
            </div>
        </div>
    </main>
    <footer class="bg-light text-center py-4 mt-5 border-top">
        <div class="container">
            <p class="mb-0 text-muted">&copy; 2025 <a href="https://www.vietnamfootage.store" target="_blank">VietnamFootage.store</a>. All Rights Reserved.</p>
        </div>
    </footer>
    <!-- Modal hướng dẫn sử dụng -->
    <div class="modal fade" id="howToUseModal" tabindex="-1">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">How to Use AI MetaGen</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <ol>
                        <li>Nhập <strong>API Key</strong>.</li>
                        <li>Chọn <strong>AI Engine</strong> và <strong>Model</strong>.</li>
                        <li>Tuỳ chỉnh <strong>Prompt</strong> nếu muốn.</li>
                        <li>Chọn hoặc kéo thả nhiều file media để upload.</li>
                        <li>Nhấn <strong>Generate Metadata</strong> để batch xử lý.</li>
                        <li>Xem kết quả/log và <strong>Export to CSV</strong>.</li>
                    </ol>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Đóng</button>
                </div>
            </div>
        </div>
    </div>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
    <script src="script.js"></script>
	


</body>
</html>
