<?php
ini_set('display_errors', 1);
error_reporting(E_ALL);
header('Content-Type: application/json');

require 'vendor/autoload.php';
use GuzzleHttp\Client;
use GuzzleHttp\Exception\RequestException;

// Ghi log
function append_process_log($msg) {
    $logfile = __DIR__ . '/uploads/process_log.txt';
    if (!is_dir(__DIR__ . '/uploads')) mkdir(__DIR__ . '/uploads', 0777, true);
    $timestamp = date('Y-m-d H:i:s');
    file_put_contents($logfile, "[$timestamp] $msg\n", FILE_APPEND);
}

// Hàm trả lỗi chuẩn JSON
function return_error($message) {
    append_process_log("Lỗi: $message");
    echo json_encode(['success' => false, 'message' => $message]);
    exit;
}

// Kiểm tra input
if (empty($_FILES['videoFile']) || !isset($_FILES['videoFile']['tmp_name'])) {
    return_error('Không có file nào được tải lên.');
}
$file = $_FILES['videoFile'];
$apikey = $_POST['apiKey'] ?? '';
$aiengine = $_POST['aiEngine'] ?? 'gemini';
$geminimodel = $_POST['geminiModel'] ?? 'gemini-2.5-flash';
$customprompt = $_POST['customPrompt'] ?? '';

if (empty($apikey)) return_error('API Key không được trống.');
if ($file['error'] !== UPLOAD_ERR_OK) return_error('Lỗi tải file lên: ' . $file['error']);

// Tạo folder lưu file, thumbnail nếu chưa có
$uploaddir = __DIR__ . '/uploads/';
$thumbnaildir = __DIR__ . '/thumbnails/';
if (!is_dir($uploaddir)) mkdir($uploaddir, 0777, true);
if (!is_dir($thumbnaildir)) mkdir($thumbnaildir, 0777, true);

$originalfilename = basename($file['name']);
append_process_log("Bắt đầu xử lý file: $originalfilename");
$sanitizedfilename = preg_replace('/[^a-zA-Z0-9-.,]/', '_', $originalfilename);
$uploadedfilepath = $uploaddir . uniqid() . '-' . $sanitizedfilename;

if (!move_uploaded_file($file['tmp_name'], $uploadedfilepath)) {
    return_error('Không thể di chuyển file tải lên.');
}
append_process_log("Đã nhận file upload: $uploadedfilepath");

// Tạo thumbnail
$fileext = strtolower(pathinfo($uploadedfilepath, PATHINFO_EXTENSION));
$outputthumbname = pathinfo($uploadedfilepath, PATHINFO_FILENAME) . '.jpg';
$outputthumbpath = $thumbnaildir . $outputthumbname;
append_process_log("Tạo thumbnail cho: $originalfilename");

$isThumbOk = true;
 

if (in_array($fileext, ['mp4','mov'])) {
    // Video (giả định có ffmpeg trong PATH)
    $cmd = "ffmpeg -y -i " . escapeshellarg($uploadedfilepath) . " -ss 00:00:03.000 -vframes 1 " . escapeshellarg($outputthumbpath);
		if (function_exists('shell_exec')) {
			$output = shell_exec($cmd);
		} else {
			// Báo lỗi hoặc bỏ qua xử lý thumbnail
			$output = '';
			// Có thể báo log hoặc cho phép tiếp tục
		}

} elseif (in_array($fileext, ['jpg','jpeg','png','bmp','webp'])) {
    @copy($uploadedfilepath, $outputthumbpath);
} elseif ($fileext === 'svg') {
    // Cần inkscape (hoặc skip nếu không có)
    $cmd = "inkscape " . escapeshellarg($uploadedfilepath) . " --export-type=png --export-filename=" . escapeshellarg($outputthumbpath);
    shell_exec($cmd);
} elseif (in_array($fileext, ['eps','ai','pdf'])) {
    // Dùng ghostscript rõ đường dẫn cho Windows
    $gsPath = '/usr/bin/gs'; // nếu cài bản 64-bit
			if (!file_exists($gsPath)) {
			unlink($uploadedfilepath);
			returnError("Ghostscript không tồn tại tại $gsPath - kiểm tra lại cài đặt hoặc chọn hosting phù hợp!");
		}

    if (!file_exists($gsPath)) {
        @unlink($uploadedfilepath);
        return_error("Ghostscript không tồn tại tại $gsPath - kiểm tra lại cài đặt!");
    }
    $cmd = "\"$gsPath\" -dNOPAUSE -dBATCH -sDEVICE=pngalpha -r150 -sOutputFile=" . escapeshellarg($outputthumbpath) . " " . escapeshellarg($uploadedfilepath);
    $output = shell_exec($cmd . ' 2>&1');
    append_process_log("Ghostscript output: " . $output);
}
 else {
    $isThumbOk = false;
}

if (!file_exists($outputthumbpath) || filesize($outputthumbpath) == 0) {
    $isThumbOk = false;
}
if (!$isThumbOk) {
    @unlink($uploadedfilepath);
    return_error("Tạo thumbnail thất bại cho file $originalfilename");
}
append_process_log("Đã tạo thumbnail: $outputthumbpath");

// Gửi API nhận metadata
$base64image = base64_encode(@file_get_contents($outputthumbpath));
$prompt = $customprompt ?: "Trích xuất metadata cho ảnh stock theo dạng: {\"title\":...,\"description\":...,\"keywords\":[...]} (trả về JSON thuần).";
$airesponsejson = null;

try {
    $client = new Client();
    if ($aiengine === "gemini") {
        $url = "https://generativelanguage.googleapis.com/v1beta/models/$geminimodel:generateContent?key=$apikey";
        $body = [
            "contents" => [
                [
                    "parts" => [
                        ["inline_data" => ["mime_type" => "image/jpeg", "data" => $base64image]],
                        ["text" => $prompt]
                    ]
                ]
            ]
        ];
        append_process_log("Gửi API Gemini...");
        $response = $client->post($url, ['json' => $body]);
        $responsestring = $response->getBody()->getContents();
        $responsedata = json_decode($responsestring, true);
        $airesponsejson = $responsedata['candidates'][0]['content']['parts'][0]['text'] ?? '';
    } else {
        // ChatGPT
        $url = "https://api.openai.com/v1/chat/completions";
        $body = [
            "model" => "gpt-4-vision-preview",
            "messages" => [
                ["role" => "user", "content" => [
                    ["type" => "text", "text" => $prompt],
                    ["type" => "image_url", "image_url" => "data:image/jpeg;base64,$base64image"]
                ]]
            ],
            "max_tokens" => 500
        ];
        append_process_log("Gửi API ChatGPT...");
        $response = $client->post($url, [
            'headers' => ['Authorization' => "Bearer $apikey"],
            'json' => $body
        ]);
        $responsestring = $response->getBody()->getContents();
        $responsedata = json_decode($responsestring, true);
        $airesponsejson = $responsedata['choices'][0]['message']['content'] ?? '';
    }
} catch (Exception $e) {
    @unlink($uploadedfilepath);
    @unlink($outputthumbpath);
    return_error("Lỗi gửi API: " . $e->getMessage());
}

append_process_log("Kết quả AI: " . substr($airesponsejson, 0, 80));

if (empty($airesponsejson)) {
    @unlink($uploadedfilepath);
    @unlink($outputthumbpath);
    return_error("API không trả về nội dung.");
}

// Trích xuất metadata JSON hoặc JSON trong markdown
$metadata = [];
if (preg_match('/\{.*\}/s', $airesponsejson, $matches)) {
    $metadata = json_decode($matches[0], true);
}
if (!$metadata || json_last_error() !== JSON_ERROR_NONE) {
    @unlink($uploadedfilepath);
    @unlink($outputthumbpath);
    return_error("Không thể phân tích metadata JSON (hoặc AI trả về kết quả lỗi/HTML). Đáp ứng: " . htmlentities(substr($airesponsejson,0,200)));
}

append_process_log("Đã phân tích metadata cho $originalfilename");

$finaldata = [
    "Filename" => $originalfilename,
    "Title" => $metadata['title'] ?? 'No Title',
    "Description" => $metadata['description'] ?? '',
    "Keywords" => is_array($metadata['keywords']) ? implode(',', $metadata['keywords']) : ($metadata['keywords'] ?? ''),
    "Category" => $metadata['categoryId'] ?? '',
    "Release" => 0,
    "Status" => "Success"
];

append_process_log("Kết thúc xử lý file $originalfilename.");

echo json_encode([
    "success" => true,
    "data" => $finaldata,
    "thumbnailpath" => "thumbnails/" . basename($outputthumbpath)
]);

exit;
