<?php
// status.php: trả trạng thái xử lý cho client (long polling)
session_start();
header('Content-Type: application/json');

$statusFile = __DIR__ . '/uploads/status.json';
if (!file_exists($statusFile)) {
    echo json_encode(['success' => false, 'status' => 'Không có tiến trình nào đang chạy']);
    exit;
}

// Đẩy thông tin trạng thái hiện tại, giả sử log vào status.json dưới dạng: {"total":100,"processed":38,"failed":2, "message":"Đang sinh metadata..."}
$statusData = json_decode(file_get_contents($statusFile), true);
echo json_encode(['success' => true, 'data' => $statusData]);
exit;
